<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Category extends Model 
{

    protected $table = 'category';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function productCategories()
    {
        return $this->hasMany('ProductCategory', 'main_category');
    }

    public function advertCategories()
    {
        return $this->hasMany('AdvertCategory', 'main_category');
    }

    public function categoryDetails()
    {
        return $this->hasMany('CategoryDetail', 'category_id');
    }

}